VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "filemonitors"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False

Option Explicit

' Declare an event that other classes can listen for
Public Event FileReceived()
Private isMonitoring As Boolean ' Tracks the monitoring state

Private WithEvents TimerScan As Timer ' Reference to the Timer control
Attribute TimerScan.VB_VarHelpID = -1
Public folderpath As String ' Path to the folder being monitored
Private LastFileList As Collection ' Track the last state of files in the folder

' Associate the Timer control with this class
Public Sub SetTimerControl(tmr As Timer)
    Set TimerScan = tmr
End Sub

' Start monitoring the folder
Public Sub StartMonitoring()

    If TimerScan Is Nothing Then
        MsgBox "Error: Timer control is not set!"
        Exit Sub
    End If

    If folderpath = "" Then
        MsgBox "Error: Folder path is not set!"
        Exit Sub
    End If

    ' Initialize the list of files
    Set LastFileList = GetFileList()

    ' Configure the Timer control
    TimerScan.Interval = 1000 ' Scan every 15 seconds
    TimerScan.Enabled = True ' Start the timer
End Sub

' Stop monitoring the folder
Public Sub StopMonitoring()
    TimerScan.Enabled = False ' Stop the timer
    Set TimerScan = Nothing ' Release the timer
End Sub

' Timer Event: Check for new files


   Private Sub TimerScan_Timer()
    Dim CurrentFileList As Collection
    Set CurrentFileList = GetFileList() ' Get the current list of files

    Dim File As Variant
    Dim NewFileFound As Boolean
    NewFileFound = False

    ' Compare the lists to detect new files
    For Each File In CurrentFileList
        If Not IsFileInList(File, LastFileList) Then
            NewFileFound = True
            Exit For
        End If
    Next File

    ' Trigger the event if new files are detected
    If NewFileFound Then
        RaiseEvent FileReceived ' Notify subscribers
    End If

    ' Update LastFileList with the current state
    Set LastFileList = New Collection
    Dim CurrentFile As Variant
    For Each CurrentFile In CurrentFileList
        LastFileList.Add CurrentFile
    Next CurrentFile
    Debug.Print "LastFileList updated. Current count: " & CurrentFileList.Count
End Sub

' Helper Function: Get a list of file names in the folder
Private Function GetFileList() As Collection
    On Error Resume Next
    Dim FSO As Object, folder As Object, File As Object
    Dim FileList As New Collection

    Set FSO = CreateObject("Scripting.FileSystemObject")
    Set folder = FSO.GetFolder(folderpath)

    For Each File In folder.Files
        FileList.Add File.Name ' Add file name to the list
    Next File

    Set GetFileList = FileList
End Function

' Helper Function: Check if a file is in the list
Private Function IsFileInList(fileName As Variant, FileList As Collection) As Boolean
    Dim File As Variant
    IsFileInList = False

    ' Loop through the collection and compare file names
    For Each File In FileList
        If File = fileName Then
            IsFileInList = True
            Exit Function
        End If
    Next File
End Function
 

Public Property Get IsRunning() As Boolean
    IsRunning = isMonitoring
End Property

